package jamezo97.clonecraft.recipe;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.ItemData;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeClearDNAItem implements IRecipe{

	@Override
	public boolean matches(InventoryCrafting ic, World world) {
		boolean foundOne = false;
		for(int a = 0; a < ic.getSizeInventory(); a++){
			ItemStack s = ic.getStackInSlot(a);
			if(s != null){
				if((s.getItem().itemID == CloneCraft.instance.needle.itemID && s.getItemDamage() != 0) ||
						(s.getItem().itemID == CloneCraft.instance.testTube.itemID && s.getItemDamage() != 0)){
					if(foundOne){
						return false;
					}
					foundOne = true;
				}else{
					return false;
				}
			}
		}
		return foundOne;
	}
	
	

	@Override
	public ItemStack getCraftingResult(InventoryCrafting ic) {
		ItemStack item = null;
		for(int a = 0; a < ic.getSizeInventory(); a++){
			ItemStack s = ic.getStackInSlot(a);
			if(s != null){
				if((s.getItem().itemID == CloneCraft.instance.needle.itemID && s.getItemDamage() != 0) ||
						(s.getItem().itemID == CloneCraft.instance.testTube.itemID && s.getItemDamage() != 0)){
					if(item != null){
						return null;
					}
					item = s;
				}
			}
		}
		if(item != null){
			ItemStack returnItem = item.copy();
			returnItem.stackSize = 1;
			returnItem.setItemDamage(0);
			ItemData itemDNA = new ItemData(returnItem);
			itemDNA.drain();
			itemDNA.save(returnItem);
			return returnItem;
		}
		return item;
	}

	@Override
	public int getRecipeSize() {
		return 0;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}
	
}
